% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_software.R
\name{plot_one_phage}
\alias{plot_one_phage}
\title{Plot Individual Phage Genome Structure with Annotations}
\usage{
plot_one_phage(
  one_phage,
  genomad_out_res,
  anno_table = NULL,
  y_var = "strand",
  fill_var = "COG",
  label_var = c("annotation_description"),
  label_wrap = 20,
  palette = "Set3"
)
}
\arguments{
\item{one_phage}{Character. Phage sequence identifier (e.g., "k141_10408").}

\item{genomad_out_res}{List. Output object from pre_genomad function containing virus summary and gene data.}

\item{anno_table}{Data frame. Optional annotation table with gene information for left join.
Must contain a 'gene' column for merging with genomad gene data.}

\item{y_var}{Character. Variable for y-axis mapping. Default is "strand".}

\item{fill_var}{Character. Variable for fill color mapping. Default is "COG".}

\item{label_var}{Character vector. Columns to use for gene description labels.}

\item{label_wrap}{Integer. Width for wrapping gene description labels. Default is 20.}

\item{palette}{Character. Color palette for fill categories. Default is "Set3".}
}
\value{
A ggplot object displaying the circular phage genome map.
}
\description{
This function creates a circular genome map for a single phage, displaying gene annotations,
functional categories, and other genomic features. It automatically extracts topology information
and provides flexible parameter customization.
}
\details{
The function automatically extracts topology information from the virus summary data
and creates a polar coordinate visualization showing:
\itemize{
\item Gene arrows indicating direction and position
\item Flexible y-axis and fill color mappings
\item Genome length and automatically detected topology information
\item Gene descriptions with intelligent label placement
}
}
