% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_two_part.R
\name{predict.hd2part}
\alias{predict.hd2part}
\title{Prediction method for two part fitted objects}
\usage{
\method{predict}{hd2part}(
  object,
  newx,
  s = NULL,
  model = c("zero", "positive"),
  type = c("link", "model_response", "response", "coefficients", "nonzero"),
  newoffset = NULL,
  ...
)
}
\arguments{
\item{object}{fitted "hd2part" model object}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be made. Must be a matrix
This argument is not used for \code{type=c("coefficients","nonzero")}}

\item{s}{Value(s) of the penalty parameter lambda for the zero part at which predictions are required. Default is the entire sequence used to create
the model.}

\item{model}{either \code{"zero"} for the zero part model or \code{"positive"} for the positive part model}

\item{type}{Type of prediction required. \code{type = "link"} gives the linear predictors;
\code{type = "model_response"} gives the fitted probabilities for the zero part and fitted expected values for the positive part.
\code{type = "response"} gives the combined response prediction across the two models using the full unconditional expected
value of the response. When \code{type = "response"}, argument \code{"model"} is unused.
\code{type = "coefficients"} computes the coefficients at the requested values for \code{s}.}

\item{newoffset}{f an offset is used in the fit, then one must be supplied for making predictions}

\item{...}{not used}
}
\value{
An object depending on the type argument
}
\description{
Prediction method for two part fitted objects
}
\examples{
set.seed(1)
}
