% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.solar.spectra.data.r
\docType{data}
\name{gap.mspct}
\alias{gap.mspct}
\title{Solar spectral irradiance in a tree canopy gap (measured)}
\format{
A \code{source_mspct} object containing a collection of 72
  \code{source_spct} objects.
}
\usage{
gap.mspct
}
\description{
A dataset containing a sequence of 72 spectra measured with an 
  Ocean Optics Maya2000 Pro spectrometer and a Bentham DH-7-SM cosine 
  diffuser. Values measured on 30 April 2014, in the late morning, under
  clear sky conditions. The whole sequence was measured in 39 seconds in a
  sunfleck under young silver birch trees. Place: University of Helsinki,
  Viikki Campus, Finland. Coordinates: 60.227162 N, 25.019429 E. Calibration
  and corrections done with package MayaCalc using bracketing and noise
  reduction (with filter measurement) and method "sun". Algorithm and
  calibration data by Lasse Ylianttila (STUK, Helsinki, Finland).
}
\details{
The variables are as follows: 
\itemize{ 
\item w.length (nm), range 293 to 800 nm. 
\item s.e.irrad (W m-2 nm-1)
}
}
\examples{
length(gap.mspct)
summary(gap.mspct)
e_irrad(gap.mspct, attr2tb = "when.measured")
  
}
\references{
Ylianttila, L.; Visuri, R.; Huurto, L. & Jokela, K. (2005) 
  Evaluation of a single-monochromator diode array spectroradiometer for 
  sunbed UV-radiation measurements. Photochem Photobiol, 81, 333-341
}
\author{
T. Matthew Robson and Saara Hartikainen (data).
}
\keyword{datasets}
