% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral.data.r
\docType{data}
\name{McCree_mean.mspct}
\alias{McCree_mean.mspct}
\title{McCree's mean action spectra for whole-leaf photosynthesis}
\format{
A \code{source_mspct} object containing two spectra. Two
numeric variables \code{w.length} and \code{s.q.response} contain the data,
and the member name identifies the spectra based on the conditions
under plants where grown.
}
\usage{
McCree_mean.mspct
}
\description{
Two action spectra computed as the mean of action spectra for different crop
plant species. Grown under two different conditions: field or controlled
environment chamber.
}
\details{
These two spectra were published by McCree et al. (1972) with
numeric data in Tables III and IV given from 350 nm to 740 nm. The
wavelength resolution is 25 nm in the original data. The wavelength
resolution was increased by natural spline interpolation and do not exactly
match the hand-drawn plots in McCree et al. (1972). These spectra are
used as biological spectral weighting functions in the computation of
"Photosynthetic Yield Photon Flux" (YPD).
}
\references{
McCree, K. J. (1972) The action spectrum, absorptance and quantum yield of
photosynthesis in crop plants. \emph{Agricultural Meteorology}, 9:191-216.
\doi{10.1016/0002-1571(71)90022-7}.
}
\seealso{
\code{\link{PAR}} and
 \code{\link[photobiologyPlants]{McCree_photosynthesis.mspct}}.
}
\keyword{datasets}
