% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orange.r
\name{Orange}
\alias{Orange}
\title{Constructor of orange waveband}
\usage{
Orange(std = "ISO")
}
\arguments{
\item{std}{a character string "ISO"}
}
\value{
A waveband object defining a wavelength range.
}
\description{
Wavelength-range definition for \emph{orange} radiation according to ISO.
}
\details{
Orange radiation (591...610 nm) as defined in ISO standards based
  on human colour vision.
}
\examples{
Orange()
Orange("ISO")

e_irrad(sun.spct, Orange()) # W m-2
q_irrad(sun.spct, Orange()) # mol m-2
q_irrad(sun.spct, Orange(), scale.factor = 1e6) # umol m-2

}
\references{
ISO (2007) Space environment (natural and artificial) - Process for
determining solar irradiances. ISO Standard 21348. ISO, Geneva.
}
\seealso{
\code{\link[photobiology]{waveband}}

Other unweighted wavebands: 
\code{\link{Blue}()},
\code{\link{Far_red}()},
\code{\link{Green}()},
\code{\link{IR}()},
\code{\link{Purple}()},
\code{\link{Red}()},
\code{\link{UV}()},
\code{\link{UVA}()},
\code{\link{UVB}()},
\code{\link{UVC}()},
\code{\link{VIS}()},
\code{\link{Yellow}()}
}
\concept{unweighted wavebands}
