% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_detection.R
\name{detect_communities_leiden}
\alias{detect_communities_leiden}
\title{Leiden community detection}
\usage{
detect_communities_leiden(g, resolution = 1)
}
\arguments{
\item{g}{An igraph graph object with weighted edges}

\item{resolution}{Resolution parameter for Leiden algorithm. Higher values
produce more communities. Default is 1.0.}
}
\value{
An igraph communities object
}
\description{
Performs community detection on a weighted graph using the Leiden algorithm
with CPM (Constant Potts Model) objective function.
}
\details{
The Leiden algorithm is a community detection method that optimizes a quality
function (here CPM). It guarantees connected communities and is generally
faster than Louvain while producing better quality partitions.
}
\examples{
data(HVGERM)
d <- igDistance(HVGERM[1:10], method = "hamming")
g <- distance_to_graph(d)
comm <- detect_communities_leiden(g, resolution = 0.5)

}
\seealso{
\code{\link{distance_to_graph}}, \code{\link{optimize_resolution}}
}
