% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhs_data_funs.R
\name{rhs_calc_nm}
\alias{rhs_calc_nm}
\title{Generate Right-hand side data (NONMEM)}
\usage{
rhs_calc_nm(
  rhs,
  inputs,
  est_parms = NULL,
  nm_res_file = NULL,
  time_nn = NULL,
  act = NULL,
  beta = 20
)
}
\arguments{
\item{rhs}{(string) String of right-hand side, e.g., "NNc + DOSE * NNct".}

\item{inputs}{(dataframe) Dataframe of inputs, with corresponding columns (including matching column names 
for each variable in \emph{rhs}, e.g., for NNc, DOSE, and NNct).}

\item{est_parms}{(named vector; semi-optional) Named vector of estimated parameters from the NN extracted through the \emph{pre_fixef_extractor_mlx} function. For optionality, see \strong{Details}.}

\item{nm_res_file}{(string; semi-optional) (path)/name of the results file of a NONMEM run, must include file extension, e.g., “.res”. For optionality, see \strong{Details}.}

\item{time_nn}{(boolean vector) Vector for each NN in \emph{rhs} defining whether the neural network is a time-dependent neural network or not. Default value for all NN is FALSE.}

\item{act}{(character vector) Vector for each NN in \emph{rhs} defining the activation function used in the NN. Default value for all NN is "ReLU".}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if any \emph{act} is softplus; Default to 20.}
}
\value{
Dataframe with columns for the inputs and the combined right-hand side data.
}
\description{
This functions allows to generate right-hand side data, i.e., combined derivative data of multiple NNs and base-R operations.
}
\details{
Either \emph{est_parms} or \emph{nm_res_file} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\author{
Dominic Bräm
}
\keyword{internal}
