% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{statin42}
\alias{statin42}
\title{FDA statin dataset with 42 adverse events}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 43 rows and 7 columns.
}
\source{
\url{https://fis.fda.gov/extensions/FPD-QDE-FAERS/FPD-QDE-FAERS.html}
}
\usage{
statin42
}
\description{
An adverse event-drug count dataset (contingency table)
obtained from the FDA FAERS database for the
quarters 2014Q3 - 2020Q4.
}
\details{
Data are stored in the form of a contingency table, with
drugs listed across the columns and the 42 AEs presented across
the rows. Each cell in the contingency table represents the total
report counts associated with that (AE, drug) pair and detected
in the FDA FAERS database during 2014Q3 - 2020Q4.

The dataset catalogs 6 statin drugs (across columns):

Atorvastatin, Fluvastatin, Lovastatin, Pravastatin, Rosuvastatin and
Simvastatin.

This dataset is derived from the \code{statin46} dataset in the \pkg{pvLRT}
package, with four AEs removed.

The excluded AEs are:
"Blood Creatine Phosphokinase Mm Increased",
"Myoglobin Blood Present",
"Myoglobin Urine Present", and
"Myoglobinaemia".
}
\keyword{datasets}
