% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{remove_blanks}
\alias{remove_blanks}
\title{Remove Blanks}
\usage{
remove_blanks(data_frame, variable, which = "all")
}
\arguments{
\item{data_frame}{A data frame which contains the character variables from which blanks
should be removed.}

\item{variable}{Variable name of the one from which to remove blanks.}

\item{which}{"all" by default. Can be "leading", "trailing", "trim", "normalize" or "all".
Determines which blanks should be removed}
}
\value{
Returns a character vector with removed blanks.
}
\description{
Removes leading and trailing blanks or both. Can also remove all blanks from a
character or normalize multiple blanks to single ones.
}
\examples{
# Example data frame
my_data <- dummy_data(100)
my_data[["blanks"]] <- " This  is  a  test "

# Remove blanks
my_data[["leading"]]   <- my_data |> remove_blanks(blanks, which = "leading")
my_data[["trailing"]]  <- my_data |> remove_blanks(blanks, which = "trailing")
my_data[["trim"]]      <- my_data |> remove_blanks(blanks, which = "trim")
my_data[["all"]]       <- my_data |> remove_blanks(blanks, which = "all")
my_data[["normalize"]] <- my_data |> remove_blanks(blanks, which = "normalize")

}
\seealso{
Other character manipulating functions: \code{\link[=concat]{concat()}}, \code{\link[=sub_string]{sub_string()}}
}
