% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relocate.R
\name{relocate.corpus}
\alias{relocate.corpus}
\title{Change column order of document variables}
\usage{
\method{relocate}{corpus}(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to move.}
}
\value{
A corpus with document variables reordered.
}
\description{
Use \code{relocate()} to change the column positions of document variables, using
the same syntax as \link[=select.corpus]{select()} to make it easy to move blocks
of columns at once.
}
\examples{
data_corpus_inaugural \%>\%
  relocate(President, Party) \%>\%
  summary(n = 5)

data_corpus_inaugural \%>\%
  relocate(FirstName, President, .before = Year) \%>\%
  summary(n = 5)
}
