% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_schema.R
\name{evidence_summary}
\alias{evidence_summary}
\title{Summarize Evidence}
\usage{
evidence_summary(ev)
}
\arguments{
\item{ev}{A valid evidence data.frame.}
}
\value{
A data.frame with columns: \code{indicator_domain}, \code{severity}, \code{result},
\code{source_name}, and \code{n}.
}
\description{
Returns a summary data.frame with counts grouped by domain, severity,
result, and source.
}
\examples{
ctx <- suppressMessages(r4sub_run_context("STUDY1", "DEV"))
ev <- suppressMessages(as_evidence(
  data.frame(
    asset_type = "validation", asset_id = "ADSL",
    source_name = "pinnacle21", indicator_id = "SD0001",
    indicator_name = "SD0001", indicator_domain = "quality",
    severity = "high", result = "fail",
    stringsAsFactors = FALSE
  ),
  ctx = ctx
))
evidence_summary(ev)

}
