% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeRank.R
\name{visualizeRank}
\alias{visualizeRank}
\title{Visualize top transcription factors (TFs) from ChEA3 results}
\usage{
visualizeRank(
  df_result,
  y_metric = c("auto", "FDR", "FET p-value", "Score"),
  fdr_threshold = 0.05,
  p_threshold = 0.05,
  query_name = "myGeneList",
  title_plot = "rChEA3 results (transcription factor enrichment analysis)",
  top_n = 10,
  fill_color = "#7AAACE"
)
}
\arguments{
\item{df_result}{A ChEA3 result data frame. Must contain at least columns:
\itemize{
\item \code{TF} (transcription factor symbol),
\item \code{Rank} (integer rank).
Optionally: \code{FDR}, \verb{FET p-value}, \code{Score}.
}}

\item{y_metric}{Character; which metric to use on the y-axis. One of:
\itemize{
\item \code{"auto"} (default): use FDR if present, otherwise FET p-value, otherwise Score.
\item \code{"FDR"}: use FDR (requires \code{FDR} column).
\item \code{"FET p-value"}: use Fisher’s exact test p-value (requires \verb{FET p-value} column).
\item \code{"Score"}: use Score (used in integrated meanRank/topRank).
}}

\item{fdr_threshold}{Numeric; FDR cutoff for significance (default \code{0.05}).
Used only if \code{y_metric = "FDR"}.}

\item{p_threshold}{Numeric; p-value cutoff for significance (default \code{0.05}).
Used only if \code{y_metric = "FET p-value"}.}

\item{query_name}{Character; name of the input gene set, shown in the subtitle (default \code{myGeneList})}

\item{title_plot}{Character; main plot title (default \verb{rChEA3 results (transcription factor enrichment analysis)})}

\item{top_n}{Integer; number of TFs to display (default \code{10}). The subtitle
reports the total number of significant TFs, while only the top_n by rank
are plotted.}

\item{fill_color}{Character; fill color of the bars (default \code{"#7AAACE"}).}
}
\value{
A \code{ggplot} object.
}
\description{
Create a bar plot of the most significant transcription factors from a
ChEA3 result table. The y-axis can be based on \code{FDR}, \verb{FET p-value},
or \code{Score} (for integrated results). Bars are ordered by rank (Rank = 1
at the top).
}
\details{
The plot subtitle automatically reports the number of \emph{significant TFs}
(after filtering by \code{fdr_threshold} or \code{p_threshold} when applicable),
while \code{top_n} controls how many of those TFs are displayed. For
integrated collections (\verb{Mean Rank} and \verb{Top Rank}), the subtitle shows
a descriptive label instead of individual library names.
}
\examples{
\donttest{
# Example with integrated meanRank results
genes <- c("STAT3", "RELA", "MYC", "FOXO1", "TP53")
results <- queryChEA3(genes, verbose = FALSE)
meanRank_res <- results[["Integrated--meanRank"]]
visualizeRank(meanRank_res, y_metric = "Score", top_n = 15)

# Example with ChIP-seq results (FET p-value-based)
chip_res <- results[["ENCODE--ChIP-seq"]]
visualizeRank(chip_res, y_metric = "FET p-value")
}
}
