% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.sim_data.R
\name{print.summary.sim_data}
\alias{print.summary.sim_data}
\title{Print \code{summary.sim_data} Object}
\usage{
\method{print}{summary.sim_data}(x, ...)
}
\arguments{
\item{x}{\code{summary.sim_data} object; returned by \code{\link{summary.sim_data}} function}

\item{...}{further arguments passed to or from other methods;
currently none specified}
}
\value{
None
}
\description{
Print \code{summary.sim_data} Object
}
\examples{

# data preparation
library(terra)

n1_small <- rast(system.file("input_maps/n1_small.tif", package = "rangr"))
K_small <- rast(system.file("input_maps/K_small.tif", package = "rangr"))

sim_data <- initialise(
  n1_map = n1_small,
  K_map = K_small,
  r = log(2),
  rate = 1 / 1e3
)
summary_sim_data <- summary(sim_data)
print(summary_sim_data)

}
