% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.aov.R
\name{report.aov}
\alias{report.aov}
\alias{report_effectsize.aov}
\alias{report_table.aov}
\alias{report_statistics.aov}
\alias{report_parameters.aov}
\alias{report_model.aov}
\alias{report_info.aov}
\alias{report_text.aov}
\title{Reporting ANOVAs}
\usage{
\method{report}{aov}(x, ...)

\method{report_effectsize}{aov}(x, include_intercept = FALSE, ...)

\method{report_table}{aov}(x, include_intercept = FALSE, ...)

\method{report_statistics}{aov}(x, table = NULL, ...)

\method{report_parameters}{aov}(x, ...)

\method{report_model}{aov}(x, table = NULL, ...)

\method{report_info}{aov}(x, effectsize = NULL, ...)

\method{report_text}{aov}(x, table = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{aov}, \code{anova} or \code{aovlist}.}

\item{...}{Arguments passed to or from other methods.}

\item{include_intercept}{Set to \code{TRUE} to include the intercept (relevant for type-3 ANOVA tables).}

\item{table}{Provide the output of \code{report_table()} to avoid its re-computation.}

\item{effectsize}{Provide the output of \code{report_effectsize()} to avoid
its re-computation.}
}
\value{
An object of class \code{\link[=report]{report()}}.
}
\description{
Create reports for ANOVA models.
}
\examples{
data <- iris
data$Cat1 <- rep(c("A", "B"), length.out = nrow(data))

model <- aov(Sepal.Length ~ Species * Cat1, data = data)
r <- report(model)
r
summary(r)
as.data.frame(r)
summary(as.data.frame(r))
}
\seealso{
Specific components of reports (especially for stats models):
\itemize{
\item \code{\link[=report_table]{report_table()}}
\item \code{\link[=report_parameters]{report_parameters()}}
\item \code{\link[=report_statistics]{report_statistics()}}
\item \code{\link[=report_effectsize]{report_effectsize()}}
\item \code{\link[=report_model]{report_model()}}
\item \code{\link[=report_priors]{report_priors()}}
\item \code{\link[=report_random]{report_random()}}
\item \code{\link[=report_performance]{report_performance()}}
\item \code{\link[=report_info]{report_info()}}
\item \code{\link[=report_text]{report_text()}}
}

Other types of reports:
\itemize{
\item \code{\link[=report_system]{report_system()}}
\item \code{\link[=report_packages]{report_packages()}}
\item \code{\link[=report_participants]{report_participants()}}
\item \code{\link[=report_sample]{report_sample()}}
\item \code{\link[=report_date]{report_date()}}
}

Methods:
\itemize{
\item \code{\link[=as.report]{as.report()}}
}

Template file for supporting new models:
\itemize{
\item \code{\link[=report.default]{report.default()}}
}
}
