% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resmush_file.R
\name{resmush_file}
\alias{resmush_file}
\title{Optimize a local file}
\usage{
resmush_file(
  file,
  suffix = "_resmush",
  overwrite = FALSE,
  progress = TRUE,
  report = TRUE,
  qlty = 92,
  exif_preserve = FALSE
)
}
\arguments{
\item{file}{Path or paths to local files. \strong{reSmush} can optimize the
following image files:
\itemize{
\item \code{png}
\item \code{jpg/jpeg}
\item \code{gif}
\item \code{bmp}
\item \code{tiff}
}}

\item{suffix}{Character, defaults to \code{"_resmush"}. By default, a new file
with the suffix is created in the same directory than \code{file}. (i.e.,
optimized \code{example.png} would be \code{example_resmush.png}). Values \code{""}, \code{NA}
and \code{NULL} would be the same than \code{overwrite = TRUE}.}

\item{overwrite}{Logical. Should the file in \code{file} be overwritten? If \code{TRUE}
\code{suffix} would be ignored.}

\item{progress}{Logical. Display a progress bar when needed.}

\item{report}{Logical. Display a summary report of the process in the
console. See also \strong{Value}.}

\item{qlty}{Only affects \code{jpg} files. Integer between 0 and 100 indicating
the optimization level. For optimal results use vales above 90.}

\item{exif_preserve}{Logical. Should the
\href{https://en.wikipedia.org/wiki/Exif}{Exif} information (if any) deleted?
Default is to remove it (i.e. \code{exif_preserve = FALSE}).}
}
\value{
Writes on disk the optimized file if the API call is successful in the
same directory than \code{file}.

With the option \code{report = TRUE} a summary report is displayed in the
console. In all cases, a (invisible) data frame with a summary of the
process used for generate the report is returned.
}
\description{
Optimize local images using the \href{https://resmush.it/}{reSmush.it API}.
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}

\donttest{
png_file <- system.file("extimg/example.png", package = "resmush")

# For the example, copy to a temporary file
tmp_png <- tempfile(fileext = ".png")

file.copy(png_file, tmp_png, overwrite = TRUE)

resmush_file(tmp_png)

# Several paths
jpg_file <- system.file("extimg/example.jpg", package = "resmush")
tmp_jpg <- tempfile(fileext = ".jpg")

file.copy(jpg_file, tmp_jpg, overwrite = TRUE)

# Output summary in console
summary <- resmush_file(c(tmp_png, tmp_jpg))

# Similar info in an (invisible) data frame as a result
summary


# Display with png
if (require("png", quietly = TRUE)) {
  my_png <- png::readPNG(summary$dest_img[1])
  grid::grid.raster(my_png)
}

# With parameters
resmush_file(tmp_jpg)
resmush_file(tmp_jpg, qlty = 10)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://resmush.it/api/}{reSmush.it API} docs.

See \code{\link[=resmush_clean_dir]{resmush_clean_dir()}} to clean a directory of previous runs.

Other functions for optimizing:
\code{\link{resmush_dir}()},
\code{\link{resmush_url}()}
}
\concept{optimize}
