% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-reeb-graph.R
\name{reeb_graph}
\alias{reeb_graph}
\alias{print.reeb_graph}
\alias{format.reeb_graph}
\alias{read_reeb_graph}
\title{An S3 class and constructors for Reeb graphs}
\usage{
reeb_graph(values, edgelist)

\method{print}{reeb_graph}(x, ..., n = NULL, minlength = 12L)

\method{format}{reeb_graph}(x, ..., n = NULL, minlength = 12L)

read_reeb_graph(file)
}
\arguments{
\item{values}{Numeric vector of function values at vertices; may have names,
which may be duplicated and/or missing.}

\item{edgelist}{2-column integer matrix of linked vertex pairs.}

\item{x}{Object of class \code{reeb_graph}.}

\item{...}{Additional arguments passed to \code{\link[base:format]{base::format()}}.}

\item{n}{Integer number of edges to print.}

\item{minlength}{Minimum name abbreviation length; passed to
\code{\link[base:abbreviate]{base::abbreviate()}}.}

\item{file}{A plain text file containing Reeb graph data formatted as at
\code{ReebGraphPairing}.}
}
\value{
An object of class \code{"reeb_graph"}, which is a list of two elements:
\itemize{
\item \code{values}: Numeric vector of function values at vertices, optionally named.
\item \code{edgelist}: 2-column integer matrix of linked vertex pairs.
}
}
\description{
This is an S3 class with associated constructors for a data
structure to represent Reeb graphs in R.
}
\details{
Vertex indices start at zero, for consistency with examples. The
positions of \code{values} and the integer values in \code{edgelist} will correspond
to the same vertices; \code{length(values)} must bound \code{max(edgelist)}.

The S3 class is a list of \code{"values"} and \code{"edgelist"}. The \code{\link[=print]{print()}} method
prints one edge per line, with nodes formatted as "\code{index[name] (value)}"
}
\examples{
x <- reeb_graph(
  values = c(a = 0, b = .4, c = .6, d = 1),
  edgelist = rbind( c(1,2), c(1,3), c(2,4), c(3,4))
)
print(x)

t10 <- system.file("extdata", "10_tree_iterations.txt", package = "rgph")
( y <- read_reeb_graph(t10) )

reeb_graph_pairs(x, method = "multi_pass")
reeb_graph_pairs(y, method = "multi_pass")

}
\references{
\url{https://github.com/USFDataVisualization/ReebGraphPairing/}
}
\seealso{
\code{\link[=as_reeb_graph]{as_reeb_graph()}}
}
