% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{runRichCluster}
\alias{runRichCluster}
\title{Run clustering in C++ backend}
\usage{
runRichCluster(
  terms,
  geneIDs,
  distanceMetric,
  distanceCutoff,
  linkageMethod,
  linkageCutoff
)
}
\arguments{
\item{terms}{Character vector of term names}

\item{geneIDs}{Character vector of geneIDs}

\item{distanceMetric}{e.g. "kappa"}

\item{distanceCutoff}{numeric between 0 and 1}

\item{linkageMethod}{e.g. "average"}

\item{linkageCutoff}{numeric between 0 and 1}
}
\value{
A list containing the clustering results with the following components:
\describe{
  \item{distance_matrix}{A numeric matrix containing pairwise distances between terms based on gene similarity}
  \item{all_clusters}{A data frame with columns 'Cluster' (cluster ID) and 'TermIndices' (comma-separated indices of terms in each cluster)}
  \item{linkage_tree}{The hierarchical clustering dendrogram structure from the agglomerative clustering process}
}
}
\description{
Run clustering in C++ backend
}
