% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x13.R
\name{regarima}
\alias{regarima}
\alias{regarima_fast}
\title{RegARIMA model, pre-adjustment in X13}
\usage{
regarima(
  ts,
  spec = c("rg4", "rg0", "rg1", "rg2c", "rg3", "rg5c"),
  context = NULL,
  userdefined = NULL
)

regarima_fast(
  ts,
  spec = c("rg4", "rg0", "rg1", "rg2c", "rg3", "rg5c"),
  context = NULL,
  userdefined = NULL
)
}
\arguments{
\item{ts}{an univariate time series.}

\item{spec}{the model specification. Can be either the name of a predefined
specification or a user-defined specification.}

\item{context}{list of external regressors (calendar or other) to be used for
estimation}

\item{userdefined}{a vector containing additional output variables
(see \code{\link[=x13_dictionary]{x13_dictionary()}}).}
}
\value{
the \code{regarima()} function returns a list with the results
(\code{"JD3_REGARIMA_RSLTS"} object), the estimation specification and the result
specification, while \code{regarima_fast()} is a faster function that only returns
the results.
}
\description{
RegARIMA model, pre-adjustment in X13
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
library("rjd3toolkit")

y <- rjd3toolkit::ABS$X0.2.09.10.M
sp <- regarima_spec("rg5c")
sp <- add_outlier(sp,
    type = c("AO"), c("2015-01-01", "2010-01-01")
)
regarima_fast(y, spec = sp)
sp <- set_transform(
    set_tradingdays(
        set_easter(sp, enabled = FALSE),
        option = "workingdays"
    ),
    fun = "None"
)
regarima_fast(y, spec = sp)
sp <- set_outlier(sp, outliers.type = c("AO"))
regarima_fast(y, spec = sp)
}
\dontshow{\}) # examplesIf}
}
