% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_simulation.R
\name{add_linear_outcome}
\alias{add_linear_outcome}
\title{Create a linear outcome by summing effects}
\usage{
add_linear_outcome(data, output_col = "y_linear")
}
\arguments{
\item{data}{A data frame containing effect columns prefixed with \code{"."}.}

\item{output_col}{Name of the column to store the linear outcome (default \code{"y_linear"}).}
}
\value{
A \code{tibble} with the added linear outcome column.
}
\description{
Generates a linear outcome variable by summing all columns that start with \code{"."} (representing fixed, random, and error effects).
}
\examples{
df <- tibble::tibble(.beta = 0.5, .u = rnorm(5), .error = rnorm(5))
add_linear_outcome(df)
}
