% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_likelihood_pmodel.R
\name{cost_likelihood_pmodel}
\alias{cost_likelihood_pmodel}
\title{Cost function computing a log-likelihood for calibration of P-model
parameters}
\usage{
cost_likelihood_pmodel(
  par,
  obs,
  drivers,
  targets,
  par_fixed = NULL,
  parallel = FALSE,
  ncores = 2
)
}
\arguments{
\item{par}{A named vector of values for the parameters to be calibrated, including
a subset of model parameters (described in \code{\link{runread_pmodel_f}}),
in order, and error terms
for each target variable (for example \code{'gpp_err'}), in the same order as
the targets appear in \code{targets}.}

\item{obs}{A nested data.frame of observations, with columns \code{'sitename'}
and \code{'data'} (see \code{\link{p_model_validation}} or \code{\link{p_model_validation_vcmax25}}
to check their structure).}

\item{drivers}{A nested data.frame of driver data. See \code{\link{p_model_drivers}}
for a description of the data structure.}

\item{targets}{A character vector indicating the target variables for which the
optimization will be done and the RMSE computed. This string must be a column 
name of the \code{data} data.frame belonging to the validation nested data.frame 
(for example 'gpp').}

\item{par_fixed}{A named list of model parameter values to keep fixed during the
calibration. These should complement the input \code{par} such that all model
parameters are passed on to \code{\link{runread_pmodel_f}}.}

\item{parallel}{A logical specifying whether simulations are to be parallelised
(sending data from a certain number of sites to each core). Defaults to
\code{FALSE}.}

\item{ncores}{An integer specifying the number of cores used for parallel
computing. Defaults to 2.}
}
\value{
The log-likelihood of the observed target values, assuming that they
are independent, normally distributed and centered on the predictions
made by the P-model run with standard deviation given as input (via `par` because
the error terms are estimated through the calibration with `BayesianTools`,
as shown in the "Parameter calibration and cost functions" vignette).
}
\description{
The cost function performs a P-model run for the input drivers and model parameter
values, and computes the outcome's normal log-likelihood centered at the input
observed values and with standard deviation given as an input parameter 
(calibratable).
}
\details{
To run the P-model, all model parameters must be given. The cost
function uses arguments \code{par} and \code{par_fixed} such that, in the
calibration routine, \code{par} can be updated by the optimizer and 
\code{par_fixed} are kept unchanged throughout calibration.

If the validation data contains a "date" column (fluxes), the simulated target time series
is compared to the observed values on those same dates (e.g. for GPP). Otherwise, 
there should only be one observed value per site (leaf traits), and the outputs 
(averaged over the growing season, weighted by predicted GPP) will be 
compared to this single value representative of the site (e.g. Vcmax25). As an exception,
when the date of a trait measurement is available, it will be compared to the 
trait value predicted on that date.
}
\examples{
# Compute the likelihood for a set of 
# model parameter values involved in the
# temperature dependence of kphio 
# and example data
cost_likelihood_pmodel(
par = c(kphio       = 0.05, 
        kphio_par_a = -0.01, 
        kphio_par_b = 1,     # model parameters
        err_gpp     = 2),    # err_gpp
 obs = p_model_validation,
 drivers = p_model_drivers,
 targets = c('gpp'),
 par_fixed = list(
  soilm_thetastar    = 0.6 * 240,  # old setup with soil moisture stress
  soilm_betao        = 0.0,
  beta_unitcostratio = 146.0,
  rd_to_vcmax        = 0.014,      # from Atkin et al. 2015 for C3 herbaceous
  tau_acclim         = 30.0,
  kc_jmax            = 0.41
 )
)
}
