% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pmodel_onestep_f_bysite.R
\name{run_pmodel_onestep_f_bysite}
\alias{run_pmodel_onestep_f_bysite}
\title{Run P-model (single time step)}
\usage{
run_pmodel_onestep_f_bysite(lc4, forcing, params_modl, makecheck = TRUE)
}
\arguments{
\item{lc4}{Locigical specifying whether P-model simulation is for C4 (as opposed to C3). Defaults to \code{FALSE}.}

\item{forcing}{A data frame of forcing climate data, used as input (single row).}

\item{params_modl}{A named list of free (calibratable) model parameters. See \code{\link{runread_pmodel_f}}}

\item{makecheck}{A logical specifying whether checks are performed 
 to verify forcings and model parameters. \code{TRUE} by default.

For further specifications of above inputs and examples see \code{\link{p_model_drivers}} or \code{\link{p_model_drivers_vcmax25}}}
}
\value{
Model output is provided as a tidy dataframe, with columns:
\describe{
  \item{\code{vcmax}}{Maximum rate of RuBisCO carboxylation 
      (Vcmax) (in mol C m\eqn{^{-2}} s\eqn{^{-1}}).}
  \item{\code{jmax}}{Maximum rate of electron transport for RuBP regeneration
      (in mol CO\eqn{_2} m\eqn{^{-2}} s\eqn{^{-1}}).}
  \item{\code{vcmax25}}{Maximum rate of carboxylation (Vcmax), 
      normalised to 25\eqn{^o}C (in mol C m\eqn{^{-2}} s\eqn{^{-1}}).}
  \item{\code{jmax25}}{Maximum rate of electron transport, normalised to 
      25\eqn{^o}C (in mol C m\eqn{^{-2}} s\eqn{^{-1}}).}
  \item{\code{gs_accl}}{Acclimated stomatal conductance (in 
      mol C (mol photons)\eqn{^{-1}} Pa\eqn{^{-1}}. (Multiply by 
      ppfd (mol photons m\eqn{^{-2}} d\eqn{^{-1}}) and fapar 
      to express per unit ground area and time.)}
  \item{\code{chi}}{Ratio of leaf-internal to ambient CO\eqn{_{2}}, ci:ca (unitless).}
  \item{\code{iwue}}{Intrinsic water use efficiency (iWUE) (unitless, 
      multiply with patm (Pa) to get iWUE in Pa).}
  \item{\code{rd}}{Dark respiration (Rd) in gC m\eqn{^{-2}} s\eqn{^{-1}}. 
      (Multiply by 1/12 (mol C / gC) to convert to mol C m\eqn{^{-2}} s\eqn{^{-1}}.)}
  \item{\code{bigdelta}}{13C isotope discrimination of leaf assimilates 
       against atmospheric signature (permil).}
  }
}
\description{
Run P-model on a single site for a single time step. This does not include the simulation of ecosystem-level quantities,
water limitation, nor a simulation of water fluxes. Instead, this corresponds to a leaf-level representation of the 
acclimation of photosynthesis.
}
\details{
TBC
}
\examples{
# Define model parameter values from previous work
params_modl <- list(
  kphio              = 0.04998,    # setup ORG in Stocker et al. 2020 GMD
  kphio_par_a        = 0.0,        # disable temperature-dependence of kphio
  kphio_par_b        = 1.0,
  beta_unitcostratio = 146.0,
  rd_to_vcmax        = 0.014,      # from Atkin et al. 2015 for C3 herbaceous
  kc_jmax            = 0.41
)

# Run the Fortran P-model 
run_pmodel_onestep_f_bysite(
  lc4 = FALSE,
  forcing = data.frame(
    temp  = 20,           # temperature, deg C
    vpd   = 1000,         # Pa,
    ppfd  = 300/10^6,     # mol/m2/s
    co2   = 400,          # ppm,
    patm  = 101325        # Pa
  ),
  params_modl = list(
    kphio              = 0.04998,    # setup ORG in Stocker et al. 2020 GMD
    kphio_par_a        = 0.0,        # disable temperature-dependence of kphio
    kphio_par_b        = 1.0,
    beta_unitcostratio = 146.0,
    rd_to_vcmax        = 0.014,      # from Atkin et al. 2015 for C3 herbaceous
    kc_jmax            = 0.41
  ),
  makecheck = TRUE
)
}
