% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSingleGene.R
\name{plotSingleGene}
\alias{plotSingleGene}
\title{Bar plot of single gene expression (Delta Delta Ct method)}
\usage{
plotSingleGene(
  res,
  col_width = 0.8,
  err_width = 0.15,
  color = "black",
  alpha = 1,
  base_size = 12,
  d = 0.4,
  ...
)
}
\arguments{
\item{res}{An object created by the \code{ANOVA_DDCt()} function}

\item{col_width}{Numeric. Width of bars (default \code{0.8})}

\item{err_width}{Numeric. Width of error bars (default \code{0.15})}

\item{color}{Optional color for the bar outline}

\item{alpha}{Numeric. Transparency of bars (default \code{1})}

\item{base_size}{Numeric. Base font size for theme (default \code{12})}

\item{d}{Distance between horizontal significance lines}

\item{...}{Additional ggplot2 layer arguments}
}
\value{
A bar plot of Delta Delta Ct showing pairwise significance
}
\description{
Creates a bar plot of relative gene expression (fold change) values
from single gene analysis
}
\examples{
res <- ANOVA_DDCt(
data_2factor,
numOfFactors = 2,
mainFactor.column = 2,
numberOfrefGenes = 1,
block = NULL,
analyseAllTarget = TRUE) # If you have multi-target gene data, specify a single target gene.

plotSingleGene(res, fill = "cyan4", color = "black", base_size = 12)
}
