% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SprErr.R
\name{SprErr}
\alias{SprErr}
\title{Compute the ratio between the ensemble spread and RMSE}
\usage{
SprErr(
  exp,
  obs,
  dat_dim = NULL,
  memb_dim = "member",
  time_dim = "sdate",
  pval = TRUE,
  sign = FALSE,
  alpha = 0.05,
  na.rm = FALSE,
  ncores = NULL
)
}
\arguments{
\item{exp}{A named numeric array of experimental data with at least two 
dimensions 'memb_dim' and 'time_dim'.}

\item{obs}{A named numeric array of observational data with at least two 
dimensions 'memb_dim' and 'time_dim'. It should have the same dimensions as
parameter 'exp' except along 'dat_dim' and 'memb_dim'.}

\item{dat_dim}{A character string indicating the name of dataset (nobs/nexp) 
dimension. The default value is NULL (no dataset).}

\item{memb_dim}{A character string indicating the name of the member 
dimension. It must be one dimension in 'exp' and 'obs'. The default value 
is 'member'.}

\item{time_dim}{A character string indicating the name of dimension along
which the ratio is computed. The default value is 'sdate'.}

\item{pval}{A logical value indicating whether to compute the p-value 
of the test Ho : SD/RMSE = 1 or not. The default value is TRUE.}

\item{sign}{A logical value indicating whether to retrieve the statistical
significance of the test Ho: ACC = 0 based on 'alpha'. The default value is
FALSE.}

\item{alpha}{A numeric indicating the significance level for the statistical
significance test. The default value is 0.05.}

\item{na.rm}{A logical value indicating whether to remove NA values. The 
default value is FALSE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list of two arrays with dimensions c(nexp, nobs, the rest of 
 dimensions of 'exp' and 'obs' except memb_dim and time_dim), which nexp is
 the length of dat_dim of 'exp' and nobs is the length of dat_dim of 'obs'. 
 If dat_dim is NULL, nexp and nobs are omitted. \cr
\item{$ratio}{
 The ratio of the ensemble spread and RMSE.
}
\item{$p_val}{
 The p-value of the two-sided Fisher's test with Ho: Spread/RMSE = 1. Only 
 present if \code{pval = TRUE}.
}
}
\description{
Compute the ratio between the spread of the members around the 
ensemble mean in experimental data and the RMSE between the ensemble mean of 
experimental and observational data. The p-value and/or the statistical 
significance is provided by a two-sided Fisher's test.
}
\examples{
exp <- array(rnorm(30), dim = c(lat = 2, sdate = 3, member = 5))
obs <- array(rnorm(30), dim = c(lat = 2, sdate = 3))
sprerr1 <- SprErr(exp, obs)
sprerr2 <- SprErr(exp, obs, pval = FALSE, sign = TRUE)
sprerr3 <- SprErr(exp, obs, pval = TRUE, sign = TRUE)

}
