% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignDatetags.R
\name{assignDatetags}
\alias{assignDatetags}
\alias{assignDatetags.snowprofileSet}
\alias{assignDatetags.snowprofile}
\alias{assignDatetags.snowprofileLayers}
\title{Assign layers in simulated snow profiles to precomputed datetags}
\usage{
assignDatetags(
  x,
  potentialDatetags,
  vdate = NULL,
  adjust_bdates = FALSE,
  computeBDate = TRUE,
  checkMonotonicity = ifelse(computeBDate, TRUE, FALSE),
  ...
)

\method{assignDatetags}{snowprofileSet}(
  x,
  potentialDatetags,
  vdate = NULL,
  adjust_bdates = FALSE,
  computeBDate = TRUE,
  checkMonotonicity = ifelse(computeBDate, TRUE, FALSE),
  ...
)

\method{assignDatetags}{snowprofile}(
  x,
  potentialDatetags,
  vdate = NULL,
  adjust_bdates = FALSE,
  computeBDate = TRUE,
  checkMonotonicity = ifelse(computeBDate, TRUE, FALSE),
  ...
)

\method{assignDatetags}{snowprofileLayers}(
  x,
  potentialDatetags,
  vdate,
  adjust_bdates = FALSE,
  computeBDate = TRUE,
  checkMonotonicity = ifelse(computeBDate, TRUE, FALSE),
  ...
)
}
\arguments{
\item{x}{a \link{snowprofileSet}, \link{snowprofile} or \link{snowprofileLayers} object}

\item{potentialDatetags}{a character or Date array of all potential datetags of the season. This array is currently provided by
\code{sarp.2021.herla.snowprofilevalidation::derivePotentialDatetags()} only.}

\item{vdate}{date when the profile and layer information is valid (i.e., \code{profile$date})}

\item{adjust_bdates}{boolean switch to compute bdates that are more similar to human interpretation. Deprecated and not recommeneded, see Details.}

\item{computeBDate}{compute burial dates (\code{bdate}s) from layer deposition dates?}

\item{checkMonotonicity}{check ascending order of layers. This acts as a check for whether multiple layers objects are stacked, which is not allowed.}

\item{...}{passed on to subsequent methods}
}
\value{
The input object will be returned with the columns \code{datetag} and \code{bdate} added to the profile layers
}
\description{
This routine assigns each layer of simulated snow profiles to precomputed datetags. Conceptually, each datetag represents a date
when the surface layers get buried by new snow. To assign layers to datetags, the routine chooses the closest datetag that is older than the
layer formation date. This routine needs precomputed datetags, which are currently computed based on precipitation patterns
by functions in other packages. Once layers are assigned to datetags, layers from different locations or times can easily
be grouped by their datetags.
}
\details{
As a side effect and to issue warnings when layers might not be assigned to meaningful datetags,
the routine also computes the exact burial dates (\code{bdate}s) of layers, which is the \code{ddate} of the overlying layer.
For snowpack simulations with thin layer
resolution, this approach yields very similar \code{ddate}s and \code{bdate}s for most layers, since most layers form and
instantly get buried by another layer of the same storm. Before implementing the aforementioned approach of pre-computing datetags
based on weather patterns, this routine attempted to make \code{bdate}s more similar to human interpretation by adjusting
\code{bdate}s, so that (similar) layers with the same \code{ddate} (i.e., same storm) inherit the same \code{bdate}
(similar means: identical gtype & hardness). This feature is still available by setting \code{adjust_bdates} to TRUE, which is not
recommended, though.
}
\section{Methods (by class)}{
\itemize{
\item \code{assignDatetags(snowprofileSet)}: for \link{snowprofileSet}s

\item \code{assignDatetags(snowprofile)}: for \link{snowprofile}s

\item \code{assignDatetags(snowprofileLayers)}: for \link{snowprofileLayers}

}}
\examples{
## TODO: create a meaningful example!

}
\seealso{
\link{deriveBDate}, \link{guessDatetagsSimple}
}
\author{
fherla
}
