% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend_multi.R
\name{scMetaTraj_trend_multi}
\alias{scMetaTraj_trend_multi}
\title{Compute trends and switchpoints for multiple modules along mPT}
\usage{
scMetaTraj_trend_multi(
  score_mat,
  mPT,
  modules,
  n_bins = 30,
  smooth = TRUE,
  span = 0.3
)
}
\arguments{
\item{score_mat}{Matrix/data.frame (cells x modules). Row order must match mPT.}

\item{mPT}{Numeric vector (length = n_cells).}

\item{modules}{Character vector of module names (columns of score_mat).}

\item{n_bins}{Integer. Number of mPT bins.}

\item{smooth}{Logical. Whether to loess smooth.}

\item{span}{Numeric. Loess span.}
}
\value{
A list with:
\itemize{
\item trend_long: long-format data.frame for plotting
\item switchpoints: data.frame of module-wise switchpoints
}
}
\description{
Compute trends and switchpoints for multiple modules along mPT
}
