% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_independent_t_test_table.R
\name{make_independent_t_test_table}
\alias{make_independent_t_test_table}
\title{Create a one-row summary table for an independent-samples t-test}
\usage{
make_independent_t_test_table(data, outcome, group)
}
\arguments{
\item{data}{A data frame containing the outcome and grouping variables.}

\item{outcome}{Character string specifying the numeric outcome variable.}

\item{group}{Character string specifying the grouping variable. Must have exactly two levels.}
}
\value{
A single-row data frame with the following columns:
\itemize{
\item \code{test}: Name of the statistical test
\item \code{group1}, \code{group2}: Group labels
\item \code{mean_diff}: Mean difference between groups (group1 - group2)
\item \code{t_value}: t statistic
\item \code{df}: Degrees of freedom
\item \code{p_value}: p-value
\item \code{n_group1}, \code{n_group2}: Sample sizes per group
\item \code{cohens_d}: Cohen's d effect size
\item \code{interpretation}: Qualitative interpretation of effect size
}
}
\description{
This function performs an independent-samples t-test (Welch's t-test by default)
between two groups defined by a binary grouping variable and returns a
single-row, report-ready data frame. The output includes group names,
sample sizes, mean difference, test statistics, p-value, and effect size
(Cohen's d) with a qualitative interpretation.
}
\details{
The function is intended for streamlined reporting and does not introduce
new statistical methods. All computations rely on \code{stats::t.test()}.

Welch’s t-test is used by default, which does not assume equal variances.
Cohen’s d is computed using the pooled standard deviation for comparability
with conventional benchmarks. Group ordering follows the factor level order
of the grouping variable.
}
\examples{
set.seed(123)

data_t <- data.frame(
  group = rep(c("CBT", "Psychodynamic"), each = 30),
  score = c(
    rnorm(30, mean = 18, sd = 4),
    rnorm(30, mean = 21, sd = 4)
  )
)

make_independent_t_test_table(
  data = data_t,
  outcome = "score",
  group = "group"
)
}
