% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_burn_probability.R
\name{flp20_to_bp_df}
\alias{flp20_to_bp_df}
\title{Process multiple FLP20 files into a combined data frame}
\usage{
flp20_to_bp_df(files)
}
\arguments{
\item{files}{A character vector of paths to FLP20 .csv files.}
}
\value{
A single, combined data frame containing processed data from all input files.
}
\description{
Applies `flp20_to_df` to a list of file paths and combines the resulting data frames
into a single, large data frame. Each file represents individual fire events.
}
\examples{
# In a real scenario, 'files' would be paths to your actual FLP20 CSV files.
# For this example, we'll create a few dummy files representing individual fires.

temp_dir <- tempdir()
file1 <- file.path(temp_dir, "flp20_fire1.csv")
file2 <- file.path(temp_dir, "flp20_fire2.csv")

# Create dummy data for file1 (one fire, FL bin 10)
dummy_data1 <- data.frame(
  XPos = 50, YPos = 50, PBurn = 1,
  FIL1 = 0, FIL2 = 0, FIL3 = 0, FIL4 = 0,
  FIL5 = 0, FIL6 = 0, FIL7 = 0, FIL8 = 0,
  FIL9 = 0,
  FIL10 = 1, # This fire is in FL bin 10
  FIL11 = 0, FIL12 = 0, FIL13 = 0, FIL14 = 0,
  FIL15 = 0, FIL16 = 0, FIL17 = 0, FIL18 = 0,
  FIL19 = 0, FIL20 = 0
)
write.csv(dummy_data1, file1, row.names = FALSE)

# Create dummy data for file2 (one fire, FL bin 15)
dummy_data2 <- data.frame(
  XPos = 70, YPos = 80, PBurn = 1,
  FIL1 = 0, FIL2 = 0, FIL3 = 0, FIL4 = 0,
  FIL5 = 0, FIL6 = 0, FIL7 = 0, FIL8 = 0,
  FIL9 = 0,
  FIL10 = 0, FIL11 = 0, FIL12 = 0, FIL13 = 0,
  FIL14 = 0, FIL15 = 1, # This fire is in FL bin 15
  FIL16 = 0, FIL17 = 0, FIL18 = 0, FIL19 = 0, FIL20 = 0
)
write.csv(dummy_data2, file2, row.names = FALSE)

# List of files to process
my_files <- c(file1, file2)

# Process the files
combined_df <- flp20_to_bp_df(my_files)
print(head(combined_df))

# Clean up dummy files
unlink(my_files)

}
