% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{jsonenc}
\alias{jsonenc}
\title{JSON Encode}
\usage{
jsonenc(x)
}
\arguments{
\item{x}{An R object to encode as JSON.}
}
\value{
A character string containing the JSON representation.
}
\description{
Minimal JSON encoder. Converts an R object to a JSON string.
}
\details{
This is a minimal implementation designed for creating HTTP API request
bodies.
}
\section{Type Mappings}{

\itemize{
\item Named list -> object \code{{}}
\item Unnamed list -> array \verb{[]}
\item Character -> string (with escaping)
\item Numeric/integer -> number
\item Logical -> \code{true}/\code{false}
\item \code{NULL}, \code{NA} -> \code{null}
\item Scalars (length 1) -> primitive value
\item Vectors (length > 1) -> array \verb{[]}
\item Unsupported types (e.g., functions) -> \code{null}
}
}

\examples{
jsonenc(list(name = "John", age = 30L))
jsonenc(list(valid = TRUE, count = NULL))
jsonenc(list(nested = list(a = 1, b = list(2, 3))))
jsonenc(list(nums = 1:3, strs = c("a", "b")))

}
\seealso{
\code{\link[=jsondec]{jsondec()}}
}
