% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fetch_data_core}
\alias{fetch_data_core}
\title{Core Data Fetching Function}
\usage{
fetch_data_core(
  endpoint,
  params,
  auth_token,
  verbose = FALSE,
  enrich_response = TRUE,
  processor = process_response
)
}
\arguments{
\item{endpoint}{Character. API endpoint path (e.g. "ios/sales_report_estimates").}

\item{params}{List. Query parameters.}

\item{auth_token}{Character. API token.}

\item{verbose}{Logical. Whether to print debug messages.}

\item{enrich_response}{Logical. Whether to enrich the response with metadata.}

\item{processor}{Function. Function to process the response. Defaults to process_response.}
}
\value{
A tibble with the results.
}
\description{
A reusable function to handle the common pattern of fetching data from the API.
Handles URL building, request execution, error handling, and response processing.
}
\keyword{internal}
