% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fetch_unified_data}
\alias{fetch_unified_data}
\title{Fetch and Unified Data from Platforms}
\usage{
fetch_unified_data(
  ios_app_id = NULL,
  android_app_id = NULL,
  start_date,
  end_date,
  countries,
  date_granularity,
  auth_token,
  verbose = FALSE,
  combine_to_unified = TRUE
)
}
\arguments{
\item{ios_app_id}{Character. iOS App ID.}

\item{android_app_id}{Character. Android App ID.}

\item{start_date}{Date. Start date.}

\item{end_date}{Date. End date.}

\item{countries}{Character vector. Country codes.}

\item{date_granularity}{Character. Granularity.}

\item{auth_token}{Character. API token.}

\item{verbose}{Logical. Verbose output.}

\item{combine_to_unified}{Logical. Whether to sum metrics into a unified view.}
}
\value{
A tibble with columns date, country, revenue, downloads, and optionally platform/app_id.
}
\description{
Fetches data from iOS and/or Android and optionally combines them.
Handles missing data from one platform gracefully.
}
\keyword{internal}
