% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature.test.R
\name{feature.test}
\alias{feature.test}
\title{Weighted permutation test for paired difference of means}
\usage{
feature.test(var1, var2, weights, n = 2000)
}
\arguments{
\item{var1}{A numeric vector.}

\item{var2}{A numeric vector of the same length as \code{var1}.}

\item{weights}{A numeric vector of non-negative weights of the same length as \code{var1} and \code{var2}.}

\item{n}{Integer. Number of permutations (default 2000).}
}
\value{
A list with:
\describe{
  \item{mean_wmshap_diff}{Observed weighted mean difference (var1 - var2).}
  \item{p_value}{Monte Carlo permutation p-value.}
}
}
\description{
Performs a weighted permutation test for the null hypothesis that the
             weighted mean of (var1 - var2) is zero.
}
\examples{
\dontrun{
var1 <- rnorm(100)
var2 <- rnorm(100)
weights <- runif(100)
result <- shapley:::feature.test(var1, var2, weights)
result$mean_wmshap_diff
result$p_value
}
}
