% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TestStationarity}
\alias{TestStationarity}
\title{Test Stationarity}
\usage{
TestStationarity(x, margin = 1)
}
\arguments{
\item{x}{Numeric matrix.}

\item{margin}{Numeric scalar specifying the stationarity threshold.
Values less than 1 indicate stricter stationarity criteria.}
}
\description{
The function computes the eigenvalues of the input matrix \code{x}.
It checks if all eigenvalues have moduli less than 1.
If all eigenvalues have moduli less than 1,
the system is considered stationary.
}
\examples{
x <- matrix(
  data = c(0.5, 0.3, 0.2, 0.4),
  nrow = 2
)
TestStationarity(x)

x <- matrix(
  data = c(0.9, -0.5, 0.8, 0.7),
  nrow = 2
)
TestStationarity(x)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMInterceptEta}()},
\code{\link{SSMInterceptY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
\keyword{test}
