% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTreatment.R
\name{simTreatment}
\alias{simTreatment}
\title{Simulate Event History Data with Treatment and Time-Dependent Covariate}
\usage{
simTreatment(
  N,
  eta = rep(0.1, 4),
  nu = rep(1.1, 4),
  beta_L_A = 1,
  beta_L_D = 1,
  beta_A_D = -1,
  beta_A_L = -0.5,
  beta_L0_A = 1,
  beta_L0_L = 1,
  beta_L0_D = 1,
  beta_L0_C = 0,
  beta_L_C = 0,
  beta_A_C = 0,
  beta_L_A_prime = 0,
  beta_L_D_prime = 0,
  beta_A_D_prime = 0,
  beta_A_L_prime = 0,
  beta_L0_A_prime = 0,
  beta_L0_L_prime = 0,
  beta_L0_D_prime = 0,
  beta_L0_C_prime = 0,
  beta_L_C_prime = 0,
  beta_A_C_prime = 0,
  t_prime = NULL,
  at_risk_cov = NULL,
  cens = 1,
  op = 1,
  lower = 10^(-15),
  upper = 200,
  followup = Inf,
  ...
)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate.}

\item{eta}{Numeric vector of length 4. Shape parameters for Weibull intensities, parameterized as
\eqn{\eta \nu t^{\nu - 1}}. Default is \code{rep(0.1, 4)}.}

\item{nu}{Numeric vector of length 4. Scale parameters for Weibull hazards. Default is \code{rep(1.1, 4)}.}

\item{beta_L_A}{Numeric. Effect of covariate \code{L = 1} on treatment hazard. Default 1.}

\item{beta_L_D}{Numeric. Effect of covariate \code{L = 1} on death hazard. Default 1.}

\item{beta_A_D}{Numeric. Effect of treatment \code{A = 1} on death hazard. Default -1.}

\item{beta_A_L}{Numeric. Effect of treatment \code{A = 1} on covariate hazard. Default -0.5.}

\item{beta_L0_A}{Numeric. Effect of baseline covariate \code{L0} on treatment hazard. Default 1.}

\item{beta_L0_L}{Numeric. Effect of baseline covariate \code{L0} on covariate hazard. Default 1.}

\item{beta_L0_D}{Numeric. Effect of baseline covariate \code{L0} on death hazard. Default 1.}

\item{beta_L0_C}{Numeric. Effect of baseline covariate \code{L0} on censoring hazard. Default 0.}

\item{beta_L_C}{Numeric. Effect of covariate \code{L = 1} on censoring hazard. Default 0.}

\item{beta_A_C}{Numeric. Effect of treatment \code{A = 1} on censoring hazard. Default 0.}

\item{beta_L_A_prime}{Numeric. Additional effect of covariate \code{L = 1} on treatment hazard. Default 0.}

\item{beta_L_D_prime}{Numeric. Additionalffect of covariate \code{L = 1} on death hazard. Default 0.}

\item{beta_A_D_prime}{Numeric. Effect of treatment \code{A = 1} on death hazard. Default 0.}

\item{beta_A_L_prime}{Numeric. Effect of treatment \code{A = 1} on covariate hazard. Default 0.}

\item{beta_L0_A_prime}{Numeric. Effect of baseline covariate \code{L0} on treatment hazard. Default 0.}

\item{beta_L0_L_prime}{Numeric. Effect of baseline covariate \code{L0} on covariate hazard. Default 0.}

\item{beta_L0_D_prime}{Numeric. Effect of baseline covariate \code{L0} on death hazard. Default 0.}

\item{beta_L0_C_prime}{Numeric. Effect of baseline covariate \code{L0} on censoring hazard. Default 0.}

\item{beta_L_C_prime}{Numeric. Effect of covariate \code{L = 1} on censoring hazard. Default 0.}

\item{beta_A_C_prime}{Numeric. Effect of treatment \code{A = 1} on censoring hazard. Default 0.}

\item{t_prime}{Numeric scalar or NULL. Time point where effects change (optional).}

\item{at_risk_cov}{Function. Function determining if an individual is at risk for each event type,
given their covariates. Takes a numeric vector covariates and returns a binary vector. Default returns 1 for all events.}

\item{cens}{Integer (0 or 1). Indicates if censoring is possible. Default 1.}

\item{op}{Integer (0 or 1). Indicates if treatment (operation) is possible. Default 1.}

\item{lower}{Numeric. Lower bound for root finding (inverse cumulative hazard). Default \code{1e-15}.}

\item{upper}{Numeric. Upper bound for root finding (inverse cumulative hazard). Default 200.}

\item{followup}{Numeric. Maximum censoring time. Defaults to \code{Inf} (no censoring).}

\item{...}{Additional arguments passed to \code{simEventData} or \code{simEventTV}}
}
\value{
A \code{data.frame} with columns:
\itemize{
\item \code{ID} - Individual identifier.
\item \code{Time} - Event time.
\item \code{Delta} - Event type (0=censoring, 1=death, 2=treatment, 3=covariate change).
\item \code{L0} - Baseline covariate.
\item \code{L} - Time-dependent covariate.
\item \code{A} - Treatment status.
}
}
\description{
Simulates event history data with four types of events representing censoring (0), death (1), treatment (2), and covariate change (3).
Death and censoring are terminal events; treatment and covariate events can occur only once.
}
\details{
Event intensities are modeled using Weibull hazards with parameters \eqn{\nu} (scale) and \eqn{\eta} (shape),
and covariate effects controlled by specified \code{beta} parameters. For example, \code{beta_L_A} quantifies
the effect of covariate \code{L = 1} on the hazard of treatment.
}
\examples{
simTreatment(10)
}
