% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_gs_n.R
\name{multitest}
\alias{multitest}
\title{Perform multiple tests on trial data cutting}
\usage{
multitest(data, ...)
}
\arguments{
\item{data}{Trial data cut by \code{\link[=cut_data_by_event]{cut_data_by_event()}} or \code{\link[=cut_data_by_date]{cut_data_by_date()}}}

\item{...}{One or more test functions. Use \code{\link[=create_test]{create_test()}} to change
the default arguments of each test function.}
}
\value{
A list of test results, one per test. If the test functions are named
in the call to \code{multitest()}, the returned list uses the same names.
}
\description{
WARNING: This experimental function is a work-in-progress. The function
arguments and/or returned output format may change as we add additional
features.
}
\examples{
trial_data <- sim_pw_surv(n = 200)
trial_data_cut <- cut_data_by_event(trial_data, 150)

# create cutting test functions
wlr_partial <- create_test(wlr, weight = fh(rho = 0, gamma = 0))
rmst_partial <- create_test(rmst, tau = 20)
maxcombo_partial <- create_test(maxcombo, rho = c(0, 0), gamma = c(0, 0.5))

multitest(
  data = trial_data_cut,
  wlr = wlr_partial,
  rmst = rmst_partial,
  maxcombo = maxcombo_partial
)
}
\seealso{
\code{\link[=create_test]{create_test()}}
}
