#' This class represents an SQL value.
#'
#' Used to reprensent an SQL value.
#'
#' @examples
#' # To generate the integer value 30:
#' ExprValue$new(30L)
#'
#' # To generate the string value "abcd":
#' ExprValue$new("abcd")
#'
#' @import R6
#' @include Expr.R
#' @include TokenValue.R
#' @export
ExprValue <- R6::R6Class("ExprValue",
  inherit = Expr,
  public = list(

    #' @description
    #' Initializer.
    #' @param value The value.
    #' @return Nothing.
    initialize = function(value) {
      chk::chk_scalar(value)
      private$value <- value
      return(invisible(NULL))
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      return(list(TokenValue$new(private$value)))
    }
  ),
  private = list(
    value = NULL
  )
)
