% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factories.R
\name{make_select}
\alias{make_select}
\title{Create an SQL SELECT query.}
\usage{
make_select(
  tabl,
  fields,
  distinct = FALSE,
  limit = NULL,
  where = NULL,
  join = NULL
)
}
\arguments{
\item{tabl}{A table name.}

\item{fields}{A character vector containing field names or a list of
ExprField objects.}

\item{distinct}{If set to TRUE, add the distinct keyword.}

\item{limit}{Add a limit (integer value) to the number of records returned.}

\item{where}{Set a StmtWhere instance to add a where clause.}

\item{join}{Set a StmtJoin instance to add a join clause.}
}
\value{
A SelectQuery instance.
}
\description{
Create a QuerySelectFields instance to select a set of fields. The table name
and the list of fields are the only required parameters.
}
\examples{
# Here is a simple SELECT query:
make_select("books", fields = c("title", "author"))

}
