% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_terms.R
\name{select_terms}
\alias{select_terms}
\title{Retrieve a list of interaction terms from a sdid model to be passed on for aggregation}
\usage{
select_terms(sdid, coefs = NULL, selection = NULL)
}
\arguments{
\item{sdid}{A sdid object}

\item{coefs}{Optional list of specific terms from \code{mdl} to be selected}

\item{selection}{List object containing values for named elements \code{cohorts},
\code{times}, and \code{tsi}. \code{cohorts} contains a character vector of cohort levels to
include in the term selection; \code{times} contains a character vector of time
period levels to include in the term selection; and \code{tsi} contains a vector
of integers representing the number of units of time relative to each
cohort's intervention to include in the term selection. If \code{cohorts} is
omitted, all available cohorts will be selected. One of \code{times} or \code{tsi} must
be specified. If both are specified, \code{times} is ignored.}
}
\value{
character vector
}
\description{
Retrieve a list of interaction terms from a sdid model to be passed on for aggregation
}
\examples{
# Fit a staggered difference-in-differences model
sdid_hosp <- sdid(hospitalized ~ cohort + yr + age + sex + comorb,
                          df = hosp,
                          intervention_var  = "intervention_yr")

# Select coefficients corresponding to all intervention cohorts in 2018
terms_2018 <- select_terms(sdid = sdid_hosp,
                                  selection = list(times = "2018"))
terms_2018

# Pass the set of coefficients to `ave_coeff` to aggregate the effect of the
# intervention
ave_coeff(sdid_hosp, coefs = terms_2018)

# Select coefficients corresponding to added risk of hospitalization associated with
# the intervention in the year 2018, but only for the first two cohorts (5 and 6)
terms_2018_cohorts56 <- select_terms(sdid = sdid_hosp,
                                     selection = list(cohorts = c("5", "6"),
                                                      times = "2018"))

# Pass the set of coefficients to `ave_coeff` to aggregate the effect of the
# intervention
ave_coeff(sdid_hosp, coefs = terms_2018_cohorts56)
}
