% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.utilities.R
\name{ERRVL}
\alias{ERRVL}
\alias{ERRVL2}
\alias{ERRVL3}
\title{Attempt a series of statements and return the first one that is not an error.}
\usage{
ERRVL(...)

ERRVL2(...)

ERRVL3(...)
}
\arguments{
\item{\dots}{Expressions to be attempted; for \code{ERRVL()}, should be
wrapped in \code{\link[=try]{try()}}.}
}
\value{
The first argument that is not an error. Stops with an
error if all are.
}
\description{
\code{ERRVL()} expects the potentially erring statements to be wrapped
in \code{\link[=try]{try()}}. In addition, all expressions after the first may
contain a \code{.}, which is substituted with the \code{try-error} object
returned by the previous expression.

\code{ERRVL2()} does \emph{not} require the potentially erring
statements to be wrapped in \code{\link[=try]{try()}} and will, in fact, treat them
as non-erring; it does not perform dot substitution.

\code{ERRVL3()} behaves as \code{ERRVL2()}, but it does perform
dot-substitution with the \code{\link{condition}} object.
}
\note{
This family of functions behave similarly to the \code{\link[=NVL]{NVL()}} and the \code{\link[=EVL]{EVL()}} families.

These functions use lazy evaluation, so, for example
\code{ERRVL(1, stop("Error!"))} will never evaluate the \code{\link[=stop]{stop()}} call
and will not produce an error, whereas \code{ERRVL2(solve(0), stop("Error!"))} would.
}
\examples{

print(ERRVL(1,2,3)) # 1
print(ERRVL(try(solve(0)),2,3)) # 2
print(ERRVL(1, stop("Error!"))) # No error

\dontrun{
# Error:
print(ERRVL(try(solve(0), silent=TRUE),
            stop("Error!")))
}

# Capture and print the try-error object:
ERRVL(try(solve(0), silent=TRUE),
      print(paste0("Stopped with an error: ", .)))

print(ERRVL2(1,2,3)) # 1
print(ERRVL2(solve(0),2,3)) # 2
print(ERRVL2(1, stop("Error!"))) # No error


\dontrun{
# Error:
ERRVL3(solve(0), stop("Error!"))
}

# Capture and print the error object:
ERRVL3(solve(0), print(paste0("Stopped with an error: ", .)))

# Shorthand for tryCatch(expr, error = function(e) e):
ERRVL3(solve(0), .)

}
\seealso{
\code{\link[=try]{try()}}, \code{\link[=inherits]{inherits()}}, \code{\link[=tryCatch]{tryCatch()}}
}
\keyword{utilities}
