% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/startup.utilities.R
\name{default_options}
\alias{default_options}
\title{Set \code{\link[=options]{options()}} according to a named list, skipping those already
set.}
\usage{
default_options(...)
}
\arguments{
\item{...}{see \code{\link[=options]{options()}}: either a list of \code{name=value} pairs or
a single unnamed argument giving a named list of options to set.}
}
\value{
The return value is same as that of \code{\link[=options]{options()}} (omitting
options already set).
}
\description{
This function can be useful for setting default options, which do
not override options set elsewhere.
}
\examples{
options(onesetting=1)

default_options(onesetting=2, anothersetting=3)
stopifnot(getOption("onesetting")==1) # Still 1.
stopifnot(getOption("anothersetting")==3)

default_options(list(yetanothersetting=5, anothersetting=4))
stopifnot(getOption("anothersetting")==3) # Still 3.
stopifnot(getOption("yetanothersetting")==5)
}
