% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mean.gen}
\alias{ci.mean.gen}
\title{Confidence intervals for generalized means}
\usage{
ci.mean.gen(alpha, y)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y}{vector of scores}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated mean
\item SE - recovered standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for three population generalized means
(square-root, geometric, and harmonic) using a vector of response scores as
input. The square-root mean requires non-negative scores. The geometric and
harmonic means require positive scores. The standard errors are recovered
from the confidence intervals.
}
\examples{
y <- c(32, 47, 28, 15, 20, 41, 87)
ci.mean.gen(.05, y)

# Should return:
#             Estimate       SE       LL       UL
# Square-root 35.79395 8.141122 18.64498 58.48619
# Geometric   33.26410 7.633328 19.47124 56.82741
# Harmonic    29.07073 7.978149 19.35236 58.39602
 

}
