% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop.inv}
\alias{ci.prop.inv}
\title{Confidence interval for a proportion using inverse sampling}
\usage{
ci.prop.inv(alpha, f, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{number of participants who have the attribute (fixed)}

\item{n}{sample size (random)}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of proportion
\item SE - recovered standard error
\item LL - lower limit of confidence interval
\item UL - upper limit of confidence interval
}
}
\description{
Computes an exact confidence interval for a population proportion
when inverse sampling has been used. An approximate standard error is
recovered from the confidence interval. With inverse sampling, the number
of participants who have the attribute (f) is predetermined and sampling
continues until f attains its prespecified value. With inverse sampling,
the sample size (n) will not be known in advance.

For more details, see Section 1.19 of Bonett (2021, Volume 3)
}
\examples{
ci.prop.inv(.05, 10, 87)

# Should return:
#  Estimate         SE         LL        UL
# 0.1149425 0.03389574 0.05651668 0.1893855


}
\references{
\insertRef{Zou2010}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
