% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plot_survHE.R
\name{make_newdata}
\alias{make_newdata}
\title{Creates a 'newdata' list to modify the plots for specific individual
profiles (with respect to the covariates)}
\usage{
make_newdata(data, vars, conts = NULL)
}
\arguments{
\item{data}{The original dataset that has been used as input to the call
to 'fit.models'}

\item{vars}{A vector of strings, including the names of the variables that
are to be used to construct specific profiles of individual covariates}

\item{conts}{A subset of 'vars', which include the named covariates that
are continuous. These will be averaged over, while for the remaining
covariates (assumed to be factors), the specific profiles will be listed.
Defaults to NULL}
}
\value{
\item{newdata}{The list 'newdata' to be passed as optional argument
to a call to the 'plot' method}

\item{labs}{A vector of labels (say to use in the plot, for each
profile)}
}
\description{
Creates a 'newdata' list to modify the plots for specific individual
profiles (with respect to the covariates)
}
\note{
Something will go here
}
\examples{
\dontrun{
data(bc)

# Fits a model using the 'bc' data
mle = fit.models(formula=Surv(recyrs,censrec)~group,data=bc,
    distr="exp",method="mle")
# Now makes the default plot
plot(mle)
# Now creates a 'newdata' list to modify the plot for selected profiles
newdata=make_newdata(data=bc,vars="group")
# And can plot, say, only two of the three treatment arms
plot(mle,newdata=newdata$newdata[c(1,3)],lab.profile=newdata$labs[c(1,3)])
}

}
\author{
Gianluca Baio
}
\keyword{Parametric}
\keyword{models}
\keyword{survival}
