% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits_from_qsm.R
\name{load_qsm}
\alias{load_qsm}
\title{Load and Validate a QSM File}
\usage{
load_qsm(path)
}
\arguments{
\item{path}{Character string giving the path to a QSM text file.}
}
\value{
A tibble containing the QSM data.

A tibble containing the QSM data with validated required columns:
`startX`, `startY`, `startZ`, `endX`, `endY`, `endZ`,
`cyl_ID`, `parent_ID`, `extension_ID`,
`radius_cyl`, `length`, `volume`, and `branching_order`.
An error is thrown if any required columns are missing.
}
\description{
Reads a Quantitative Structure Model (QSM) file from disk and checks
that it includes all required columns. If any expected columns are missing,
the function stops with an informative error message.
}
\examples{
qsm_path = system.file('extdata', 'tree_0744_qsm.txt', package='tReeTraits')
qsm <- load_qsm(qsm_path)
plot_qsm2d(qsm, scale=50)
}
