% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targeted-package.R
\docType{package}
\name{targeted-package}
\alias{targeted-package}
\alias{targeted}
\title{targeted: Targeted Inference}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Various methods for targeted and semiparametric inference including augmented inverse probability weighted (AIPW) estimators for missing data and causal inference (Bang and Robins (2005) \doi{10.1111/j.1541-0420.2005.00377.x}), variable importance and conditional average treatment effects (CATE) (van der Laan (2006) \doi{10.2202/1557-4679.1008}), estimators for risk differences and relative risks (Richardson et al. (2017) \doi{10.1080/01621459.2016.1192546}), assumption lean inference for generalized linear model parameters (Vansteelandt et al. (2022) \doi{10.1111/rssb.12504}).
}
\examples{
\dontrun{
example(riskreg)
example(cate)
example(ate)
example(calibration)
}
}
\references{
Bang & Robins (2005) Doubly Robust Estimation in Missing Data and
Causal Inference Models, Biometrics.

Vansteelandt & Dukes (2022) Assumption-lean inference for
generalised linear model parameters, Journal of the Royal Statistical
Society: Series B (Statistical Methodology).

Thomas S. Richardson, James M. Robins & Linbo Wang (2017) On Modeling and
Estimation for the Relative Risk and Risk Difference, Journal of the American
Statistical Association.

Mark J. van der Laan (2006) Statistical Inference for Variable Importance,
The International Journal of Biostatistics.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://kkholst.github.io/targeted/}
  \item Report bugs at \url{https://github.com/kkholst/targeted/issues}
}

}
\author{
\strong{Maintainer}: Klaus K. Holst \email{klaus@holst.it}

Authors:
\itemize{
  \item Benedikt Sommer \email{benediktsommer92@gmail.com}
  \item Andreas Nordland \email{andreasnordland@gmail.com}
}

Other contributors:
\itemize{
  \item Christian B. Pipper \email{cbpipper@gmail.com} [contributor]
}


Klaus K. Holst (Maintainer) \href{mailto:klaus@holst.it}{klaus@holst.it}
}
\keyword{internal}
\keyword{package}
