% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/after.R
\name{after}
\alias{after}
\title{Executes modifications to the result of a module}
\usage{
after(x, server = function(input, output, session, data) data, ...)
}
\arguments{
\item{x}{(\code{teal_module} or \code{teal_modules}).}

\item{server}{(\verb{function(input, output, session, data, ...)}) function to receive output data from \code{tm$server}.
Must return data}

\item{...}{Additional arguments passed to the server wrapper function by matching their formal names.}
}
\value{
A \code{teal_module} or \code{teal_modules} object with a wrapped server.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Exported to be able to use methods not to be used directly by module-developers or app-users.
Primarily used to modify the output object of module.
}
\examples{
library("teal.reporter")
hide_code <- function(input, output, session, data) {
  teal_card(data) <- Filter(function(x) !inherits(x, "code_chunk"), teal_card(data))
  data
}
app <- init(
  data = teal_data(IRIS = iris, MTCARS = mtcars),
  modules = example_module() |>
    after(server = hide_code)
)

if (interactive()) {
  runApp(app)
}
}
\seealso{
\code{\link[=disable_src]{disable_src()}}, \code{\link[=disable_report]{disable_report()}}
}
\keyword{internal}
