% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chinese_colors.R
\name{ChineseColors}
\alias{ChineseColors}
\title{Chinese traditional colors system}
\usage{
ChineseColors()
}
\value{
A \code{ChineseColors} object.
Detailed information can be found in \code{\link[=print.ChineseColors]{print.ChineseColors()}}.
}
\description{
A color system based on Chinese traditional colors with 1058 colors.
}
\examples{
cc <- ChineseColors()
cc

# Get a color by pinyin
get_colors("pinlan")

# By number
get_colors(44)

# By hex code
get_colors("#2B73AF")

# Multiple colors
get_colors("pinlan", "piao")
get_colors(91:100)

# Chinese names
cc$visual_colors(
  title = "Chinese Traditional Colors",
  name_type = "chinese"
)

# pinyin as names
cc$visual_colors(
  loc_range = c(1, 120),
  title = "Chinese Traditional Colors",
  name_type = "pinyin"
)

# rgb as names
cc$visual_colors(
  loc_range = c(1, 120),
  title = "Colors with RGB values",
  name_type = "rgb"
)

# hex as names
cc$visual_colors(
  loc_range = c(1, 120),
  title = "Colors with hex codes",
  name_type = "hex"
)
}
\seealso{
\link{chinese_colors} for the dataset of Chinese traditional colors.
\link{get_chinese_palettes} for getting Chinese color palettes.
\link{visual_colors} for visualizing any color vector.
\link{get_colors} for searching colors in dataset and palettes.
}
