% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slim_data.R
\name{slim_data}
\alias{slim_data}
\alias{slim_data.ggplot}
\alias{slim_data.patchwork}
\title{Slim unused data in the plot}
\usage{
slim_data(p)

\method{slim_data}{ggplot}(p)

\method{slim_data}{patchwork}(p)
}
\arguments{
\item{p}{A \code{ggplot} object or a \code{patchwork} object.}
}
\value{
A \code{ggplot} or \code{patchwork} object with unused data columns removed.
}
\description{
Remove unused columns from the data in a ggplot or patchwork object.
This function keeps only the columns that are actually used in the plot
(e.g., in mappings, aesthetics, or facets), which can significantly reduce
the object size when the original data contains many unused columns.
}
\examples{
library(ggplot2)
p <- ggplot(
  data = mtcars,
  aes(x = mpg, y = wt, colour = cyl)
) +
  geom_point()
object.size(p)
colnames(p$data)

p_slim <- slim_data(p)
object.size(p_slim)
colnames(p_slim$data)
}
