% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_format_conversion.R
\name{genotype_conversion}
\alias{genotype_conversion}
\alias{gen_tidy2compact}
\alias{gen_compact2wide}
\alias{gen_tidy2wide}
\alias{gen_wide2structure}
\alias{gen_tidy2integers}
\alias{gen_tidy2genalex}
\title{Conversion among genotype formats: tidy, compact, wide, STRUCTURE}
\usage{
gen_tidy2compact(gen, delim = "/")

gen_compact2wide(gen)

gen_tidy2wide(gen)

gen_wide2structure(gen, write_out, popdata = FALSE, delim = "/")

gen_tidy2integers(gen)

gen_tidy2genalex(gen, popdata, write_out, data_name = "dataset1")
}
\arguments{
\item{gen}{Genotypes: 'tidy' in 'gen_tidy2compact()', 'gen_tidy2wide()',
'gen_tidy2genalex()', and gen_tidy2integers()';
'compact' in 'gen_compact2wide()'; 'wide' in 'gen_wide2structure()'.}

\item{delim}{Allele delimiter in genotype calls. Default "/". E.x. "AA/BB".}

\item{write_out}{File to write structure formatted genotypes
(gen_wide2structure),
or GENALEX-formatted genotypes (in 'gen_tidy2genalex').
In 'gen_tidy2genalex', genotypes are written to tab-delimited
"txt" or "xlsx", depending on the extension ("txt", "xlsx").}

\item{popdata}{Dataframe with 'sample' and 'population' columns.
Populations are added to STRUCTURE output.
If FALSE (Default), popdata is not added to STRUCTURE output.
Mandatory in 'gen_tidy2genalex'.}

\item{data_name}{Name of dataset to print to GENALEX xlsx.}
}
\value{
\itemize{
\item \emph{gen_tidy2compact}, \emph{compact} genotypes with at least 'sample' ,'locus'
and 'genotype' columns.
\item \emph{gen_compact2wide}, \emph{wide} genotypes.
\item \emph{gen_tidy2wide}, \emph{wide} genotypes.
\item \emph{gen_wide2structure}, plain text file formatted for STRUCTURE.
\item \emph{gen_tidy2genalex}, 'xls' file with genotype data for GENALEX.
\item \emph{gen_tidy2integers}, tidy genotypes with alleles recoded as
integers (1..n).
}
}
\description{
Conversion of genotype data between formats.
\itemize{
\item \emph{gen_tidy2compact}, from \emph{tidy} to \emph{compact}.
\item \emph{gen_compact2wide}, from \emph{compact} to \emph{wide}.
\item \emph{gen_tidy2wide}, from \emph{tidy} into \emph{wide}.
\item \emph{gen_wide2structure}, from \emph{wide} to STRUCTURE-formatted text file.
\item \emph{gen_tidy2genalex}, from \emph{tidy} to GENALEX-formatted \emph{xlsx} or text file.
\item \emph{gen_tidy2integers}, recode 'allele' in \emph{tidy} genotypes as integers.
}
}
\details{
Genotypes from genotype() are returned as \emph{tidy} data. Tidy data implies
one data point per row. Each row from \emph{tidy} genotypes represents an allele
call for a given sample and locus. Rows with missing data are excluded.
Thus, \emph{tidy} genotypes contain at least the three columns: \emph{sample},
\emph{locus} and \emph{allele}; bit often contain more columns (eg, \emph{reads},
\emph{allele_no}, \emph{nt}, \emph{sequence}, \emph{md5}, \emph{population}, etc.). The \emph{tidy}
format can be expanded column-wise and row-wise without altering the data
structure, and it can be easily manipulated. Some of the more handy functions
here-included involve genotype conversion between
different formats:
\itemize{
\item \emph{compact}, each row correspond to the genotype call for a given
locus in a sample.
Therefore, it only contains three columns, \emph{sample}, \emph{locus} and
\emph{genotype}. Default
separator for alleles under \emph{genotype} is '/'. For diploid data, hemizygotes
are recoded as "allele1" instead of "allele1/NA".
All other column metadata is lost.
\item \emph{wide}, genotypes are recoded in samples (rows) x loci (columns)
dataframe.
The first column \emph{samples}, contain sample names. All other columns contain
loci names.
Each cell contains genotypes in the \emph{A/B} format. Diploid genotypes are
coded as \emph{A/B}. Cells with missing data have \emph{NA_character}.
}

For the \emph{STRUCTURE} format, '-9' are introduced as missing data in
STRUCTURE output. In hemizygous calls \emph{A}, the missing allele is encoded as
missing data \emph{-9}.
Ploidy is retrieved from \emph{attributes}. Only, diploid genotypes are allowed.
}
\examples{
data("genotypes")
gencom <- gen_tidy2compact(genotypes)
gen_compact2wide(gencom)
gen_tidy2wide(genotypes)
gen_tidy2integers(genotypes)
# read metadata for sample populations
gen_str <- tempfile(fileext = ".str")
meta <-
    read.csv(system.file("extdata/metadata.csv", package = "tidyGenR"))
gen_wide2structure(gen_tidy2wide(genotypes),
    write_out = gen_str, popdata = meta
)
genalex_txt <- tempfile(fileext = ".txt")
gen_tidy2genalex(genotypes,
    popdata = meta,
    write_out = genalex_txt,
)
}
