% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{tl_tune_random}
\alias{tl_tune_random}
\title{Tune hyperparameters for a model using random search}
\usage{
tl_tune_random(
  data,
  formula,
  method,
  param_space,
  n_iter = 10,
  folds = 5,
  metric = NULL,
  maximize = NULL,
  verbose = TRUE,
  seed = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{method}{The modeling method to tune}

\item{param_space}{A named list of parameter spaces to sample from}

\item{n_iter}{Number of random parameter combinations to try}

\item{folds}{Number of cross-validation folds}

\item{metric}{Metric to optimize}

\item{maximize}{Logical; whether to maximize (TRUE) or minimize (FALSE) the metric}

\item{verbose}{Logical; whether to print progress}

\item{seed}{Random seed for reproducibility}

\item{...}{Additional arguments passed to tl_model}
}
\value{
A list with the best model and tuning results
}
\description{
Tune hyperparameters for a model using random search
}
