% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolution.R
\name{change_timeseries_resolution}
\alias{change_timeseries_resolution}
\title{Change time resolution of a time-series data frame}
\usage{
change_timeseries_resolution(dtf, resolution, method)
}
\arguments{
\item{dtf}{data.frame or tibble, first column of name \code{datetime} being
of class datetime and rest of columns being numeric}

\item{resolution}{integer, desired interval of minutes between two consecutive datetime values}

\item{method}{character, being \code{interpolate}, \code{repeat} or \code{divide} if the resolution has to be increased,
or \code{average}, \code{first} or \code{sum} if the resolution has to be decreased. See Examples for more information.}
}
\value{
tibble
}
\description{
Change time resolution of a time-series data frame
}
\examples{
fifteen_min <- data.frame(
  datetime = as.POSIXct("2024-01-01 00:00:00", tz = "UTC") + 0:7 * 900,
  load = c(10, 12, 14, 16, 14, 12, 10, 8)
)
change_timeseries_resolution(
  fifteen_min,
  resolution = 60,
  method = "average"
)



}
